<?php

/**
 * @author    Marian Roman
 * @site      www.web-adv.ro
 * @copyright 2013
 */

class Curl {

    private $ip;
    private $url = "http://whatismyipaddress.com/ip";
    private $curl;
    private $rezultat;

    function __construct() {
        if (!function_exists('curl_init')) {
            die('HOPA! pentru a functiona trebuie sa ai CURL activat.');
        }
    }

    function Detect_ip() {
        foreach (array(
            'HTTP_CLIENT_IP',
            'HTTP_X_FORWARDED_FOR',
            'HTTP_X_FORWARDED',
            'HTTP_X_CLUSTER_CLIENT_IP',
            'HTTP_FORWARDED_FOR',
            'HTTP_FORWARDED',
            'REMOTE_ADDR') as $key) {
            if (array_key_exists($key, $_SERVER) === true) {
                foreach (explode(',', $_SERVER[$key]) as $ip) {
                    $this->ip = trim($ip);

                    if (filter_var($this->ip, FILTER_VALIDATE_IP, FILTER_FLAG_NO_PRIV_RANGE | FILTER_FLAG_NO_RES_RANGE) !== false) {
                        return $this->ip;
                    }
                }
            }
        }
    }

    public function Rezultat() {
        $this->curl = curl_init();
        curl_setopt_array($this->curl, array(
            CURLOPT_URL => $this->url . '/' . $this->Detect_ip(),          
            CURLOPT_USERAGENT => $_SERVER["HTTP_USER_AGENT"].rand(1, 99999), # Nu modificati aceasta linie
            CURLOPT_TIMEOUT => 5,
            CURLOPT_RETURNTRANSFER => true));
        $this->rezultat = curl_exec($this->curl);
        curl_close($this->curl);
        return $this->rezultat;
    }

    function __destruct() {
        unset($this->curl);
    }
}

$Curl = new Curl();
$text = $Curl->Rezultat();

preg_match_all('#<tr>(.*?)</tr>#is', $text, $final);
$info_ip = preg_replace('#<tr(.*?)>(.*?)</tr>#is', "$2", $final[0]);
$info_ip = preg_replace("#<a(.*?)>(.*?)</a>#is", "", $info_ip);
$info_ip = preg_replace("#<th(.*?)>(.*?)</th>#is", "", $info_ip);
$info_ip = preg_replace("#<td(.*?)>(.*?)</td>#is", "$2", $info_ip);
$info_ip = preg_replace("/\s+/", " ", $info_ip);
$info_ip = preg_replace("#<img(.*?)\">#is", "", $info_ip);
$info_ip = preg_replace("#<input(.*?)'>#is", "", $info_ip);
$info_ip = array_filter($info_ip);
$info_ip = array_unique($info_ip);
$zona    = preg_match("/^[a-zA-Z ]+$/", $info_ip[10]);  
$oras    = preg_match("/^[a-zA-Z ]+$/", $info_ip[11]);  

if ($final[0]) {

    echo $info_ip[9] == true ? "Tara: <b>" . trim($info_ip[9]) . "</b><br>\n":"";
    if ($zona) {
        echo "Zona: <b>" . trim($info_ip[10]) . "</b><br>\n";
    }
    if ($oras) {
        echo "Oras: <b>" . trim($info_ip[11]) . "</b><br>\n";
    }
    echo "Isp : <b>" . ucwords(strtolower($info_ip[3])) ."</b><br>\n";
    echo "Ip  : <b>" . $Curl->Detect_ip() . "</b><br>\n";

    echo "<pre>\n";
    print_r($info_ip);
    echo "</pre>\n";

} else {
    echo "HOPA! ceva nu e bine.";
}

?>